// Topic 5: Function overriding and type-casting

#include <stdio.h>

class Base
{
	public:
		void Foo() { printf("BASE!\n"); }

	protected:
};

class Child : public Base
{
	public:
		Child() { m_value = 50; }

		void Foo() { printf("CHILD!\n"); }

		void Bar() { printf("Value: %d\n", m_value); }

	private:
		int m_value;
};

void main()
{
	Base* pBase1 = new Base;
	Base* pBase2 = new Child;

	pBase1->Foo();	// Will run Base version
	pBase2->Foo();	// Will ALSO run Base version!

	// You cannot call the child function through the base directly
/*	pBase2->Child::Foo(); */

	// But you can if you type-cast -> VERY DANGEROUS!
	Child* pChild = (Child*)pBase2; // We know pBase2 points to a Child
	pChild->Foo(); // No problem
	pChild->Bar(); // Also no problem

	// Let's type-cast the Base object...
	pChild = (Child*)pBase1; // pBase1 is NOT a Child!
	pChild->Foo(); // This works!! Why? Because no data members used...

	// Let's try calling a function that uses a data member in Child...
	pChild->Bar(); // This will either crash or output crap


	// Clean up
	delete pBase1;
	delete pBase2;
}